%------------------------------------------------------------------------------
% File     : SEU482^1 : TPTP v7.4.0. Bugfixed v3.7.0.
% Domain   : Set Theory (Binary relations)
% Problem  : A normalizing relation is not necessarily terminating
% Version  : [Nei08] axioms.
% English  :

% Refs     : [BN99]  Baader & Nipkow (1999), Term Rewriting and All That
%          : [Nei08] Neis (2008), Email to Geoff Sutcliffe
% Source   : [Nei08]
% Names    :

% Status   : Theorem
% Rating   : 1.00 v5.5.0, 0.83 v5.4.0, 0.80 v5.3.0, 1.00 v5.2.0, 0.80 v4.1.0, 0.67 v4.0.0, 1.00 v3.7.0
% Syntax   : Number of formulae    :   60 (   0 unit;  29 type;  29 defn)
%            Number of atoms       :  256 (  34 equality; 162 variable)
%            Maximal formula depth :   12 (   7 average)
%            Number of connectives :  163 (   6   ~;   4   |;  12   &; 124   @)
%                                         (   0 <=>;  17  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :  199 ( 199   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   31 (  29   :;   0   =)
%            Number of variables   :   89 (   0 sgn;  39   !;   7   ?;  43   ^)
%                                         (  89   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : Some proofs can be found in chapter 2 of [BN99]
%          : 
% Bugfixes : v3.7.0 - Added extra hypothesis two_individuals
%------------------------------------------------------------------------------
%----Include axioms of binary relations
include('Axioms/SET009^0.ax').
%------------------------------------------------------------------------------
thf(two_individuals,hypothesis,(
    ? [Y: $i,Z: $i] : ( Y != Z ) )).

thf(normalizing_does_not_imply_terminating,conjecture,(
    ~ ( ! [R: $i > $i > $o] :
          ( ( norm @ R )
         => ( term @ R ) ) ) )).

%------------------------------------------------------------------------------
